/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.levelEditor.editor_components;

import Data_Structures.ADTs.Bunch2;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class obj_grid
extends Obj {
    private int grid_w;
    private int grid_h;
    private int offset_x;
    private int offset_y;

    public obj_grid(int offset_x_in, int offset_y_in, int grid_w_in, int grid_h_in) {
        super(offset_x_in, offset_y_in);
        this.setGridW(grid_w_in);
        this.grid_h = grid_h_in;
        this.offset_x = offset_x_in;
        this.offset_y = offset_y_in;
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        this.drawGrid(i.getGraphics(), AT);
    }

    public void drawGrid(Graphics2D g, AffineTransform AT) {
        int w = this.myContainer.getW();
        int h = this.myContainer.getH();
        g.setColor(Color.black);
        int r = this.offset_y;
        while (r < h) {
            this.drawLine(g, AT, 0.0, r, w, r);
            r += this.grid_h;
        }
        int c = this.offset_x;
        while (c < w) {
            this.drawLine(g, AT, c, 0.0, c, h);
            c += this.getGridW();
        }
    }

    public int getGridW() {
        return this.grid_w;
    }

    public void setGridW(int grid_w) {
        this.grid_w = grid_w;
    }

    public int getGridH() {
        return this.grid_h;
    }

    public void setGridH(int grid_h) {
        this.grid_h = grid_h;
    }

    public int getOffsetX() {
        return this.offset_x;
    }

    public int getOffsetY() {
        return this.offset_y;
    }

    public Bunch2<Integer, Integer> snapToGrid(double x, double y) {
        int snapX = this.getGridW();
        int ex = (int)(x - (double)this.getOffsetX() + (double)snapX);
        ex = snapX * (ex / snapX) + this.getOffsetX() - snapX;
        int snapY = this.getGridH();
        int ey = (int)(y - (double)this.getOffsetY() + (double)snapY);
        ey = snapY * (ey / snapY) + this.getOffsetY() - snapY;
        return new Bunch2<Integer, Integer>(ex, ey);
    }

    public void snapToGrid(Obj o) {
        Bunch2<Integer, Integer> coords = this.snapToGrid(o.getX(), o.getY());
        o.moveTo(coords.getType1().intValue(), coords.getType2().intValue());
    }
}

